<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<style type="text/css">
    .panel-modern {
        border: none !important;
        border-radius: 12px !important;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06) !important;
        transition: transform 0.2s;
    }
    .panel-modern:hover {
        transform: translateY(-2px);
    }
    .quick-action-btn {
        width: 60px;
        height: 60px;
        line-height: 60px;
        border-radius: 50%;
        background: #fff;
        box-shadow: 0 4px 10px rgba(0,0,0,0.05);
        display: inline-block;
        transition: all 0.3s ease;
        border: 1px solid #f0f0f0;
    }
    .quick-action-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 15px rgba(0,0,0,0.1);
        background: #fdfdfd;
    }
    .quick-action-btn i {
        font-size: 22px;
        line-height: 60px;
    }
    .recent-job-item {
        padding: 15px 0;
        border-bottom: 1px solid #f0f0f0;
    }
    .recent-job-item:last-child {
        border-bottom: none;
    }
    .status-badge {
        padding: 5px 10px;
        border-radius: 6px;
        font-size: 11px;
        font-weight: 600;
        letter-spacing: 0.5px;
    }
    .text-title {
        color: #374151;
        font-weight: 700;
    }

    /* Header Redesign */
    .dashboard-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 30px;
        background: #fff;
        padding: 20px 30px; /* Increased padding "offset from wall" */
        border-radius: 12px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05); /* Gentle float effect */
    }
    .header-left, .header-right {
        display: flex;
        align-items: center;
    }
    .header-date-circle {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        border: 1px solid #e5e7eb;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        font-weight: bold;
        color: #111;
        margin-right: 15px;
    }
    .header-date-text {
        display: flex;
        flex-direction: column;
        line-height: 1.2;
        margin-right: 20px;
        padding-right: 20px;
        border-right: 1px solid #e5e7eb;
    }
    .header-day {
        font-weight: bold;
        color: #111;
    }
    .header-month {
        color: #6b7280;
        font-size: 13px;
    }
    .header-tasks-btn {
        background-color: #ef4444; /* Red/Orange */
        color: white;
        padding: 10px 25px;
        border-radius: 25px; /* More pill-shaped */
        font-weight: 500;
        text-decoration: none;
        display: flex;
        align-items: center;
        margin-right: 20px;
        transition: background 0.3s;
        border: none;
    }
    .header-tasks-btn:hover, .header-tasks-btn:focus {
        background-color: #dc2626;
        color: white;
        text-decoration: none;
    }
    
    /* Quick Actions in Header */
    .header-quick-action {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: #f3f4f6;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 10px;
        color: #4b5563;
        transition: all 0.2s;
        border: 1px solid transparent;
    }
    .header-quick-action:hover {
        background: #fff;
        border-color: #d1d5db;
        color: #111;
        transform: translateY(-2px);
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }

    
    .header-greeting-text {
        text-align: right;
        margin-right: 0px; /* Removed margin since mic is gone */
    }
    .header-greeting-title {
        font-size: 20px;
        font-weight: 600;
        color: #111;
    }
    .header-greeting-subtitle {
        color: #9ca3af;
        font-size: 14px;
        font-weight: 400;
        margin-top: 2px;
    }
</style>

<div id="wrapper">
    <div class="content">
        
        <!-- Custom Header -->
        <div class="row">
            <div class="col-md-12">
                <div class="dashboard-header">
                    <div class="header-left">
                        <div class="header-date-circle">
                            <?php echo date('d'); ?>
                        </div>
                        <div class="header-date-text">
                            <?php
                                // Localized Date
                                $day_en = date('l');
                                $month_en = date('F');
                                $day_loc = _l('wshop_' . strtolower($day_en));
                                $month_loc = _l('wshop_' . strtolower($month_en));
                                // Fallback if translation missing (though we added them)
                                if (strpos($day_loc, 'wshop_') !== false) $day_loc = $day_en;
                                if (strpos($month_loc, 'wshop_') !== false) $month_loc = $month_en;
                            ?>
                            <span class="header-day"><?php echo $day_loc; ?></span>
                            <span class="header-month"><?php echo $month_loc; ?></span>
                        </div>
                        
                        <!-- Main Action Button -->
                        <a href="<?php echo admin_url('tasks'); ?>" class="header-tasks-btn">
                            <?php echo _l('wshop_my_tasks'); ?> &nbsp; <i class="fa fa-arrow-right"></i>
                        </a>

                        <!-- Quick Actions (Moved here) -->
                        <a href="<?php echo admin_url('workshop/add_edit_repair_job'); ?>" class="header-quick-action" data-toggle="tooltip" title="<?php echo _l('wshop_new_job'); ?>">
                            <i class="fa fa-plus text-primary"></i>
                        </a>
                        <a href="<?php echo admin_url('workshop/inspections?new_inspection=true'); ?>" class="header-quick-action" data-toggle="tooltip" title="<?php echo _l('wshop_new_inspection'); ?>">
                            <i class="fa fa-search text-warning"></i>
                        </a>
                        <a href="<?php echo admin_url('workshop/devices'); ?>" class="header-quick-action" data-toggle="tooltip" title="<?php echo _l('wshop_fleet'); ?>">
                            <i class="fa fa-truck text-success"></i>
                        </a>

                    </div>

                    <div class="header-right">
                        <div class="header-greeting-text">
                            <div class="header-greeting-title">
                                <?php echo _l('wshop_hello'); ?>, <?php echo get_staff_full_name(); ?>! 👋
                            </div>
                            <div class="header-greeting-subtitle">
                                <?php echo _l('wshop_wishing_productive_day'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- KPI Cards -->
        <div class="row">
            <div class="col-md-3">
                <div class="panel_s panel-modern">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-xs-8">
                                <h3 class="no-margin bold text-info"><?php echo isset($count_in_progress) ? $count_in_progress : 0; ?></h3>
                                <span class="text-muted small uppercase"><?php echo _l('wshop_In_Progress'); ?></span>
                            </div>
                            <div class="col-xs-4 text-right">
                                <i class="fa fa-wrench fa-2x text-info opacity-50"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                 <div class="panel_s panel-modern">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-xs-8">
                                <h3 class="no-margin bold text-warning"><?php echo isset($count_inspection_by_status['Open']) ? $count_inspection_by_status['Open'] : 0; ?></h3>
                                <span class="text-muted small uppercase"><?php echo _l('wshop_open_inspections'); ?></span>
                            </div>
                            <div class="col-xs-4 text-right">
                                <i class="fa fa-clipboard-list fa-2x text-warning opacity-50"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                 <div class="panel_s panel-modern">
                     <div class="panel-body">
                        <div class="row">
                            <div class="col-xs-8">
                                <h3 class="no-margin bold text-danger"><?php echo count($upcoming_maintenance); ?></h3>
                                <span class="text-muted small uppercase"><?php echo _l('wshop_needs_maintenance'); ?></span>
                            </div>
                            <div class="col-xs-4 text-right">
                                <i class="fa fa-triangle-exclamation fa-2x text-danger opacity-50"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                 <div class="panel_s panel-modern">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-xs-8">
                                <h3 class="no-margin bold text-success"><?php echo isset($count_completed_today) ? $count_completed_today : 0; ?></h3>
                                <span class="text-muted small uppercase"><?php echo _l('wshop_completed_today'); ?></span>
                            </div>
                            <div class="col-xs-4 text-right">
                                <i class="fa fa-check-circle fa-2x text-success opacity-50"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Charts Section -->
            <div class="col-md-8">
                 <div class="panel_s panel-modern">
                    <div class="panel-body">
                         <h4 class="no-margin bold text-title mbot15"><?php echo _l('wshop_performance_dynamics_7_days'); ?></h4>
                         <div id="container_activity" style="height: 300px;"></div>
                    </div>
                 </div>
            </div>
             <div class="col-md-4">
                 <div class="panel_s panel-modern">
                    <div class="panel-body">
                         <h4 class="no-margin bold text-title mbot15"><?php echo _l('wshop_fleet_status'); ?></h4>
                         <div id="container_status" style="height: 300px;"></div>
                    </div>
                 </div>
            </div>
        </div>

        <div class="row">
            
            <!-- Upcoming Maintenance Grid -->
            <div class="col-md-8">
                <div class="panel_s panel-modern">
                    <div class="panel-body">
                        <div class="clearfix mbot15">
                            <h4 class="pull-left no-margin bold text-title"><?php echo _l('wshop_upcoming_maintenance_devices'); ?></h4>
                            <a href="<?php echo admin_url('workshop/devices'); ?>" class="pull-right btn btn-xs btn-info"><?php echo _l('wshop_see_all'); ?></a>
                        </div>
                        <div class="clearfix"></div>
                        <hr class="no-mtop" style="border-top: 1px solid #f3f4f6;" />

                        <div class="row">
                        <?php if(empty($upcoming_maintenance)){ ?>
                            <div class="col-md-12"><p class="text-muted text-center mtop20"><?php echo _l('wshop_no_urgent_maintenance'); ?></p></div>
                        <?php } else { ?>
                            <?php foreach($upcoming_maintenance as $device){ 
                                $hours_left = $device['next_maintenance_hour'] - $device['current_hours'];
                                $is_overdue = $hours_left < 0;
                                $badge_class = $is_overdue ? 'label-danger' : 'label-warning';
                                $label_text = $is_overdue ? _l('wshop_overdue_prefix') . abs($hours_left) . ' ' . _l('wshop_hours') : _l('wshop_due_in_prefix') . $hours_left . ' ' . _l('wshop_hours');
                                
                                $img_url = base_url('modules/workshop/assets/images/upload-image-icon.png');
                                if(!empty($device['primary_profile_image'])){
                                     $img_url = base_url('modules/workshop/uploads/main_image_devices/' . $device['id'] . '/' . $device['primary_profile_image']);
                                }
                            ?>
                            <div class="col-md-3 col-sm-6">
                                <div class="panel_s" style="border: 1px solid #f3f4f6; box-shadow: none; border-radius: 8px;">
                                    <div class="panel-body text-center p10">
                                        <div style="height: 100px; display: flex; align-items: center; justify-content: center; overflow: hidden; margin-bottom: 15px; background: #f9fafb; border-radius: 6px;">
                                            <img src="<?php echo $img_url; ?>" class="img-responsive" style="max-height: 100%; object-fit: contain;" onerror="this.onerror=null;this.src='<?php echo base_url('modules/workshop/assets/images/upload-image-icon.png'); ?>';">
                                        </div>
                                        <h5 class="bold no-margin text-ellipsis">
                                            <a href="<?php echo admin_url('workshop/device_detail/' . $device['id']); ?>" class="text-dark"><?php echo $device['name']; ?></a>
                                        </h5>
                                        <span class="label <?php echo $badge_class; ?> mtop10 display-block" style="border-radius: 4px; padding: 4px;"><?php echo $label_text; ?></span>
                                    </div>
                                </div>
                            </div>
                            <?php } ?>
                        <?php } ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column: Recent Activity (Removed Quick Actions here as they are in header) -->
            <div class="col-md-4">
                 <!-- Recent Activity -->
                 <div class="panel_s panel-modern">
                     <div class="panel-body scroller" style="max-height: 600px;"> <!-- Increased height as quick actions are gone -->
                        <h4 class="no-margin bold text-title mbot20"><?php echo _l('wshop_recent_works'); ?></h4>
                        <?php if(empty($recent_activities)){ ?>
                            <p class="text-muted"><?php echo _l('wshop_no_recent_activity'); ?></p>
                        <?php } else { ?>
                            <ul class="list-unstyled no-margin">
                            <?php foreach($recent_activities as $activity){ 
                                $status_label = _l('wshop_' . $activity['status']); 
                                if (strpos($status_label, 'wshop_') !== false) {
                                     $status_label = $activity['status']; // Fallback if translation missing
                                }
                            ?>
                                <li class="recent-job-item">
                                    <div class="row">
                                        <div class="col-xs-8">
                                            <a href="<?php echo admin_url('workshop/repair_jobs#' . $activity['id']); ?>" class="bold font-medium text-info">
                                                <?php echo _l('wshop_repair_number_prefix'); ?><?php echo $activity['id']; ?>
                                            </a>
                                            <div class="text-muted small mtop5 text-ellipsis"><?php echo $activity['device_name']; ?></div>
                                            <div class="text-muted xsmall mtop5"><i class="fa fa-clock-o"></i> <?php echo _dt($activity['datecreated']); ?></div>
                                        </div>
                                        <div class="col-xs-4 text-right">
                                            <span class="status-badge bg-light text-muted" style="border: 1px solid #ddd;"><?php echo $status_label; ?></span>
                                        </div>
                                    </div>
                                </li>
                            <?php } ?>
                            </ul>
                        <?php } ?>
                     </div>
                 </div>
            </div>

        </div>

    </div>
</div>

<?php init_tail(); ?>
<!-- Load Highcharts -->
<script src="<?php echo base_url('assets/plugins/highcharts/highcharts.js'); ?>"></script>
<script>
    $(function(){
        // Weekly Activity Chart (Dynamics)
        Highcharts.chart('container_activity', {
            chart: {  backgroundColor: 'transparent', height: 300 },
            title: { text: null },
            xAxis: {
                categories: <?php echo json_encode($weekly_chart_labels); ?>,
                gridLineWidth: 0,
                tickColor: 'transparent',
                tickLength: 0
            },
            yAxis: { title: { text: null }, gridLineColor: '#f0f0f0' },
            tooltip: { shared: true, borderRadius: 10, shadow: true, borderWidth: 0 },
            credits: { enabled: false },
            plotOptions: {
                area: {
                    fillOpacity: 0.1,
                    marker: { enabled: false, symbol: 'circle', radius: 4 },
                    lineWidth: 2,
                    states: { hover: { lineWidth: 3 } }
                },
                spline: {
                    marker: { enabled: true, symbol: 'diamond', radius: 4 },
                    lineWidth: 2
                }
            },
            series: [{
                type: 'area', /* Use area for 'Created' to show volume */
                name: '<?php echo _l('wshop_new_requests'); ?>',
                data: <?php echo json_encode($weekly_chart_data); ?>,
                color: '#2563eb', // Modern Blue
                fillColor: {
                    linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                    stops: [ [0, 'rgba(37, 99, 235, 0.2)'], [1, 'rgba(37, 99, 235, 0)'] ]
                }
            }, {
                type: 'spline', /* Use spline for 'Planned' to show trend line */
                name: '<?php echo _l('wshop_completed_fact'); ?>',
                data: <?php echo json_encode($planned_chart_data); ?>,
                color: '#10b981', // Green for completed
                dashStyle: 'Solid'
            }]
        });

        // Device Status Donut Chart
        var statusData = [];
        var totalDevices = 0;
        <?php foreach($device_status_counts as $status) { ?>
            statusData.push({
                name: '<?php echo $status['status']; ?>', 
                y: <?php echo $status['count']; ?>,
                color: '<?php echo $status['color']; ?>' 
            });
            totalDevices += <?php echo $status['count']; ?>;
        <?php } ?>
        
        Highcharts.chart('container_status', {
            chart: { type: 'pie', backgroundColor: 'transparent', height: 300 },
            title: {
                text: totalDevices, /* Display TOTAL DEVICES count, not Maintenance count */
                align: 'center',
                verticalAlign: 'middle',
                y: 10,
                style: { fontSize: '24px', fontWeight: 'bold', color: '#374151' }
            },
            tooltip: { pointFormat: '<b>{point.y}</b> ({point.percentage:.1f}%)' },
            plotOptions: {
                pie: {
                    innerSize: '70%',
                    borderWidth: 0,
                    shadow: false,
                    dataLabels: { enabled: false }
                }
            },
            credits: { enabled: false },
            series: [{
                name: '<?php echo _l('wshop_fleet'); ?>',
                data: statusData
            }]
        });
    });
</script>
</body>
</html>
